unit ucustomtranslation;

interface

uses
  SysUtils, Windows, Messages, Classes, Graphics, Controls,
  StdCtrls, ExtCtrls, Forms, Buttons, Grids, MPHexEditor, ComCtrls, ToolWin,
  Tabs, Dialogs;

type
  TdlgEditCustomTranslation = class(TForm)
    Button1: TButton;
    Button2: TButton;
    MPHexEditor1: TMPHexEditor;
    ToolBar1: TToolBar;
    btnLoad: TToolButton;
    btnSave: TToolButton;
    btnAuto: TToolButton;
    ToolButton1: TToolButton;
    TabSet1: TTabSet;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    pnPos: TPanel;
    procedure TabSet1Change(Sender: TObject; NewTab: Integer;
      var AllowChange: Boolean);
    procedure btnLoadClick(Sender: TObject);
    procedure btnSaveClick(Sender: TObject);
    procedure btnAutoClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    FOldIdle: TIdleEvent;
    FFrom,
    FTo: packed array[Byte] of Char;
    procedure ShowTable(Index: Integer);
    procedure SetTable(Index: Integer);
    // idle handler
    procedure AppIdle(Sender: TObject; var Done: Boolean);
  end;

var
  dlgEditCustomTranslation: TdlgEditCustomTranslation;

// edit custom translation
function EditCustomTranslation: Boolean;

implementation
uses umain;

{$R *.DFM}

const
  STR_ERR_UNKNOWNTABLE = 'Unknown Table Format';
  STR_ERR_TABLEVALNOTUSE = 'Byte %2x is not used in the table, so i cannot do an 1:1 translation';
  STR_ERR_TABLEVALMULTIPLE = 'Byte %2x is used multiple times, so icannot do an 1:1 translation';

// edit custom translation
function EditCustomTranslation: Boolean;
var
  LIntLoop: Integer;
begin
  with TdlgEditCustomTranslation.Create(Application) do
  try
    for LIntLoop := 0 to 255 do
    begin
      FFrom[LIntLoop] := MPHCustTransFieldFrom[LIntLoop];
      FTo[LIntLoop] := MPHCustTransFieldTo[LIntLoop];
    end;
    ShowTable(0);
    Result := ShowModal = mrok;
    if Result
    then
      for LIntLoop := 0 to 255 do
      begin
        MPHCustTransFieldFrom[LIntLoop] := FFrom[LIntLoop];
        MPHCustTransFieldTo[LIntLoop] := FTo[LIntLoop];
      end;
  finally
    Free;
  end;
end;

{ TdlgEditCustomTranslation }

procedure TdlgEditCustomTranslation.SetTable(Index: Integer);
begin
  if Index = 0
  then
    Move(MPHexEditor1.DataPointer^, FFrom, 256)
  else
    Move(MPHexEditor1.DataPointer^, FTo, 256)
end;

procedure TdlgEditCustomTranslation.ShowTable;
var
  LmstData: TMemoryStream;
  LIntLoop: Integer;
begin
  LmstData := TMemoryStream.Create;
  try
    LmstData.Size := 256;
    if Index = 0
    then
      Move(FFrom, LmstData.Memory^, 256)
    else
      Move(FTo, LmstData.Memory^, 256);

    MPHexEditor1.LoadFromStream(LmstData);

    for LIntLoop := 0 to 255
    do
      MPHexEditor1.ByteChanged[LIntLoop] := Byte(PChar(LmstData.Memory)[LIntLoop]) <> LIntLoop;
    MPHexEditor1.Repaint;

  finally
    LmstData.Free;
  end;
end;

procedure TdlgEditCustomTranslation.TabSet1Change(Sender: TObject;
  NewTab: Integer; var AllowChange: Boolean);
var
  LIntPos: Integer;
  LBoolChars: Boolean;
begin
  with MPHexEditor1 do
  begin
    LIntPos := GetCursorPos;
    LBoolChars := InCharField;
    SetTable(TabSet1.TabIndex);
    ShowTable(NewTab);
    Seek(LIntPos, soFromBeginning);
    InCharField := LBoolChars;
  end;
end;

procedure TdlgEditCustomTranslation.btnLoadClick(Sender: TObject);
var
  LfstTemp: TFileStream;
  LStrIn,
  LStrTemp: string;
  LIntSize,
  LIntPos: Integer;
begin
  with OpenDialog1
  do
    if Execute then
    begin
      LfstTemp := TFileStream.Create(FileName, fmOpenRead);
      with LfstTemp do
      try
        if Size > 255 then
        begin
          SetLength(LStrIn, Size);
          Read(LStrIn[1], Size);
          if Length(LStrIn) > 256 then
          begin
            // try to convert Hex Text;
            LStrIn := UpperCase(LStrIn);
            SetLength(LStrTemp, Length(LStrIn));
            ConvertHexToBin(PChar(LStrIn), PChar(LStrTemp), Length(LStrIn), False, LIntSize);
            if LIntSize = 256
            then
              LStrIn := Copy(LStrTemp,1,256)
            else
              if LIntSize > 256 then
              begin
                // remove 0x...
                repeat
                  LIntPos := Pos('0X', LStrIn);
                  if LIntPos = 0
                  then
                    Break;
                  Delete(LStrIn, LIntPos,2);
                until False;
                SetLength(LStrTemp, Length(LStrIn));
                ConvertHexToBin(PChar(LStrIn), PChar(LStrTemp), Length(LStrIn), False, LIntSize);
                if LIntSize = 256
                then
                  LStrIn := Copy(LStrTemp,1,256)
              end;
          end;
          if Length(LStrIn) <> 256
          then
            raise Exception.Create(STR_ERR_UNKNOWNTABLE)
          else
          begin
            if TabSet1.TabIndex = 0
            then
              Move(LStrIn[1], FFrom,256)
            else
              Move(LStrIn[1], FTo,256);
            ShowTable(TabSet1.TabIndex);
          end;
        end;
      finally
        LfstTemp.Free;
      end;
    end;
end;

procedure TdlgEditCustomTranslation.btnSaveClick(Sender: TObject);
begin
  with MPHexEditor1, SaveDialog1
  do
    if Execute then
    begin
      SaveToFile(FileName);
      HasFile := False;
    end;
end;

procedure TdlgEditCustomTranslation.btnAutoClick(Sender: TObject);
var
  LBytCheck: array[Byte] of Byte;
  LIntLoop,
  LIntLoop1: Integer;
begin
  SetTable(TabSet1.TabIndex);
  // check if the current table is unambigous
  FillChar(LBytCheck, sizeof(LBytCheck), #0);
  for LIntLoop := 0 to 255
  do
    if TabSet1.TabIndex = 0
    then
      Inc(LBytCheck[Ord(FFrom[LIntLoop])])
    else
      Inc(LBytCheck[Ord(FTo[LIntLoop])]);
  // whole check array must be set to 1 (else no 1:1 translation)
  for LIntLoop := 0 to 255
  do
    case LBytCheck[LIntLoop] of
      0: // not used, whine
        Raise Exception.CreateFmt(STR_ERR_TABLEVALNOTUSE,[LIntLoop]);
      1: ; //ok
    else
      for LIntLoop1 := 0 to 255
      do
        MPHexEditor1.ByteChanged[LIntLoop1] := MPHexEditor1.Data[LIntLoop1] = Char(LIntLoop);
      MPHexEditor1.Repaint;
      Raise Exception.CreateFmt(STR_ERR_TABLEVALMULTIPLE,[LIntLoop]);
    end;
  // all ok, create other table
  for LIntLoop := 0 to 255
  do
    if TabSet1.TabIndex = 0
    then
      FTo[Byte(FFrom[LIntLoop])] := Char(LIntLoop)
    else
      FFrom[Byte(FTo[LIntLoop])] := Char(LIntLoop)
end;

procedure TdlgEditCustomTranslation.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  SetTable(TabSet1.TabIndex);
end;

procedure TdlgEditCustomTranslation.FormCreate(Sender: TObject);
begin
  FOldIdle := Application.OnIdle;
  Application.OnIdle := AppIdle;
end;

procedure TdlgEditCustomTranslation.FormDestroy(Sender: TObject);
begin
  Application.OnIdle := FOldIdle;
end;

procedure TdlgEditCustomTranslation.AppIdle(Sender: TObject;
  var Done: Boolean);
begin
  with MPHexEditor1
  do
    pnPos.Caption := IntToHex(GetCursorPos,2)+':'+IntToHex(Byte(Data[GetCursorPos]),2)
end;

end.
